async function activateBlock(bot, blockName) {

    const blocks = await bot.findBlock({
        matching: block => blockName === block.name,
        maxDistance: 8,
        count: 1
    });

    if (blocks.length === 0) {
        bot.chat(`No ${blockName} found nearby`);
        console.log(`No ${blockName} found nearby`);
        return;
    }

    const block = bot.blockAt(blocks[0]);

    try {
        await bot.pathfinder.goto(new GoalGetToBlock(block.position.x, block.position.y, block.position.z));
        await bot.activateBlock(block);
        bot.chat(`Activated ${blockName}`);
        console.log(`Activated ${blockName}`);
        return;
    } catch (error) {
        bot.chat(`Failed to activate ${blockName}`);
        console.log(`Failed to activate ${blockName}`);
        
    }
    
}